#include <cstdio>
#include <hal/drivers/flash.h>
#include <hal/devices.h>
#include <hal/drivers/pwm.h>

int cmd_holdtime(int argc, char *argv[])
{
	if (argc != 2)
	{
		printf("%s: error, syntax: ADDRESS %s HOLD_TIME\n\n", argv[0], argv[0]);
	}
	else
	{
		pwm_file pwm;
		pwm.hold = -1;

		sscanf(argv[1], "%f", &pwm.hold);

		if (pwm.hold <= configure_file.max_hold && pwm.hold >= configure_file.min_hold)
		{
			flash_file * p_flash_file;

			fseek(p_pwm, (int) (&pwm.hold) - (int) (&pwm), SEEK_SET);
			fwrite(&pwm.hold, sizeof(pwm_file::hold), 1, p_pwm);
			fflush(p_pwm);

			decltype(p_flash_file->hold) hold = pwm.hold;
			fseek(p_flash, (int) (&p_flash_file->hold) - (int) (p_flash_file), SEEK_SET);
			fwrite(&hold, sizeof(flash_file::hold), 1, p_flash);
			fflush(p_flash);

			printf("%s: the hold time is set to: %f%%\n\n", argv[0], pwm.hold);
		}
		else
		{
			printf("%s: error, hold time: %s is not in range: %f~%f\n\n", argv[0], argv[1], configure_file.min_hold,
			    configure_file.max_hold);
		}
	}

	fflush(stdout);
}
